"use client";

import React from 'react';
import { Home, CreditCard, Bell, Settings, ShoppingCart } from 'lucide-react';
import { useTranslation } from 'react-i18next';
import { useAuth } from '../hooks/use-auth';

interface MobileNavigationProps {
  activeTab: string;
  setActiveTab: (tab: string) => void;
  tabs: Array<{ id: string; label: string }>;
}

export function MobileNavigation({ activeTab, setActiveTab, tabs }: MobileNavigationProps) {
  const { t } = useTranslation();
  const { user, orderTab } = useAuth();

  // Фильтруем табы по orderTab
  const filteredTabs = tabs.filter(tab => tab.id !== 'order' || orderTab !== false);

  const getTabIcon = (tabId: string) => {
    switch (tabId) {
      case 'dashboard':
        return <Home className="h-5 w-5" />;
      case 'payment-history':
        return <CreditCard className="h-5 w-5" />;
      case 'order':
        return <ShoppingCart className="h-5 w-5" />;
      case 'notifications':
        return <Bell className="h-5 w-5" />;
      case 'system-administration':
        return <Settings className="h-5 w-5" />;
      case 'settings':
        return <Settings className="h-5 w-5" />;
      default:
        return <Home className="h-5 w-5" />;
    }
  };

  const getTabLabel = (tabId: string) => {
    switch (tabId) {
      case 'dashboard':
        return t('navigation.dashboard', 'Dashboard');
      case 'payment-history':
        return t('navigation.payments', 'Payments');
      case 'order':
        return t('navigation.order', 'Order');
      case 'notifications':
        return t('navigation.notifications', 'Notifications');
      case 'system-administration':
        return t('navigation.settings', 'Settings');
      case 'settings':
        return t('navigation.settings', 'Settings');
      default:
        return t('navigation.dashboard', 'Dashboard');
    }
  };

  return (
    <div className="fixed bottom-0 left-0 right-0 z-50 bg-background border-t lg:hidden">
      <div className="flex justify-around items-center h-14 sm:h-16 px-2">
        {filteredTabs.map((tab) => (
          <button
            key={tab.id}
            onClick={() => setActiveTab(tab.id)}
            className={`flex flex-col items-center justify-center flex-1 h-full transition-colors px-1 ${
              activeTab === tab.id
                ? 'text-white bg-[#1B526A]'
                : 'text-muted-foreground hover:text-primary'
            }`}
          >
            <div className="flex items-center justify-center h-5 w-5 sm:h-6 sm:w-6">
              {React.cloneElement(getTabIcon(tab.id), { color: activeTab === tab.id ? 'white' : undefined })}
            </div>
            <span className="text-xs sm:text-sm mt-1 font-medium text-center">
              {getTabLabel(tab.id)}
            </span>
          </button>
        ))}
      </div>
    </div>
  );
} 