import { Capacitor } from '@capacitor/core';

export type Platform = 'desktop' | 'mobile';

export const getPlatform = (): Platform => {
  const platform = Capacitor.getPlatform();
  return platform === 'web' ? 'desktop' : 'mobile';
};

export const isMobile = (): boolean => {
  return getPlatform() === 'mobile';
};

export const isDesktop = (): boolean => {
  return getPlatform() === 'desktop';
}; 