import { useRouter } from 'next/navigation';
import { useAuth } from '@/hooks/use-auth';
import { getRoleTabs } from '@/config/tabs';
import { useTranslation } from 'react-i18next';

export default function DesktopLayout() {
  const router = useRouter();
  const { user, userRoleId } = useAuth();
  const { t } = useTranslation();
  const tabs = getRoleTabs(userRoleId ?? 0);

  return (
    <div className="flex h-screen">
      {/* Sidebar */}
      <div className="w-64 bg-gray-800 text-white">
        <div className="p-4">
          <h1 className="text-xl font-bold">MS4SC</h1>
        </div>
        <nav className="mt-4">
          {tabs.map((tab) => (
            <button
              key={tab.id}
              onClick={() => router.push(tab.href)}
              className="w-full px-4 py-2 text-left hover:bg-gray-700"
            >
              {t(`navigation.${tab.id}`, tab.label)}
            </button>
          ))}
        </nav>
      </div>

      {/* Main Content */}
      <div className="flex-1 overflow-auto">
        <main className="p-6">
          {/* Your existing desktop components will go here */}
        </main>
      </div>
    </div>
  );
} 