import { NextResponse } from 'next/server';
import { postgresClient } from '../../../../lib/postgresql-client';

export async function GET(request: Request) {
  const { searchParams } = new URL(request.url);
  const email = searchParams.get('email');
  if (!email) {
    return NextResponse.json({ error: 'Email is required' }, { status: 400 });
  }
  try {
    const userRes = await postgresClient.query('SELECT user_id, role_id, f_name, order_tab FROM users WHERE email = $1', [email]);
    if (userRes.rows.length === 0) {
      return NextResponse.json({ error: 'User not found' }, { status: 404 });
    }
    const { user_id, role_id, f_name, order_tab } = userRes.rows[0];
    const roleRes = await postgresClient.query('SELECT permissions FROM roles WHERE role_id = $1', [role_id]);
    const permissions = roleRes.rows.length ? roleRes.rows[0].permissions : null;
    return NextResponse.json({ user_id, role_id, permissions, uname: f_name, order_tab });
  } catch (error) {
    console.error('Failed to fetch user role/permissions:', error);
    return NextResponse.json({ error: 'Failed to fetch user role/permissions' }, { status: 500 });
  }
} 