import React, { useState } from 'react';
import SystemStatsCard from './SystemStatsCard';
import UserSettingsTab from './UserSettingsTab';
import PendingOrdersTab from './PendingOrdersTab';
import PaymentHistoryTab from './PaymentHistoryTab';
import { Card, CardHeader, CardTitle, CardContent } from '../components/ui/card';
import { Button } from '../components/ui/button';

const TABS = [
  { id: 'stats', label: 'Статистика', component: <SystemStatsCard /> },
  { id: 'user-settings', label: 'Настройки пользователя', component: <UserSettingsTab /> },
  { id: 'pending-orders', label: 'Ожидающие заказы', component: <PendingOrdersTab /> },
  { id: 'payment-history', label: 'История платежей', component: <PaymentHistoryTab /> },
  { id: 'push', label: 'Отправить сообщение', component: <Card><CardHeader><CardTitle>Отправить сообщение</CardTitle></CardHeader><CardContent>Форма отправки сообщения...</CardContent></Card> },
];

const SystemSettingsTab: React.FC = () => {
  const [activeTab, setActiveTab] = useState('stats');
  const isMobile = typeof window !== 'undefined' && window.innerWidth <= 768;

  if (isMobile) {
    return (
      <div>
        <div className="flex flex-col gap-2 mb-4">
          {TABS.map(tab => (
            <Button key={tab.id} variant={activeTab === tab.id ? 'default' : 'outline'} onClick={() => setActiveTab(tab.id)}>
              {tab.label}
            </Button>
          ))}
        </div>
        <div>{TABS.find(tab => tab.id === activeTab)?.component}</div>
      </div>
    );
  }

  return (
    <div>
      <div className="flex gap-2 mb-4">
        {TABS.map(tab => (
          <Button key={tab.id} variant={activeTab === tab.id ? 'default' : 'outline'} onClick={() => setActiveTab(tab.id)}>
            {tab.label}
          </Button>
        ))}
      </div>
      <div>{TABS.find(tab => tab.id === activeTab)?.component}</div>
    </div>
  );
};

export default SystemSettingsTab; 