import { useEffect, useState } from 'react';
import { getPlatform } from './ui/shared/lib/platform';
import DesktopLayout from './ui/desktop/components/layout/DesktopLayout';
import MobileLayout from './ui/mobile/components/layout/MobileLayout';
import LoginComponent from './ui/shared/components/LoginComponent';
import { useAuth } from './hooks/use-auth';
import { SplashScreen } from './components/splash-screen';

export default function App() {
  const [platform, setPlatform] = useState<'desktop' | 'mobile' | null>(null);
  const { user, loading } = useAuth();

  useEffect(() => {
    setPlatform(getPlatform());
  }, []);

  if (loading || platform === null) {
    return <SplashScreen />;
  }

  if (!user) {
    return <LoginComponent />;
  }

  return platform === 'desktop' ? <DesktopLayout /> : <MobileLayout />;
} 