import { useRouter } from 'next/navigation';
import { useAuth } from '@/hooks/use-auth';
import { getRoleTabs } from '@/config/tabs';

export default function MobileLayout() {
  const router = useRouter();
  const { user, userRoleId } = useAuth();
  const tabs = getRoleTabs(userRoleId || 0); // Default to role 0 if null

  return (
    <div className="flex flex-col h-screen bg-gray-50">
      {/* Header */}
      <header className="bg-white shadow-sm">
        <div className="px-4 py-3">
          <h1 className="text-lg font-semibold text-gray-900">MS4SC</h1>
        </div>
      </header>

      {/* Main Content */}
      <main className="flex-1 overflow-auto p-4">
        {/* Your mobile components will go here */}
      </main>

      {/* Bottom Navigation */}
      <nav className="bg-white border-t border-gray-200">
        <div className="flex justify-around">
          {tabs.map((tab) => (
            <button
              key={tab.id}
              onClick={() => router.push(tab.href)}
              className="flex flex-col items-center p-2 text-gray-600 hover:text-gray-900"
            >
              <span className="text-sm">{tab.label}</span>
            </button>
          ))}
        </div>
      </nav>
    </div>
  );
} 