"use client";

import React, { useEffect, useState } from 'react';
import { useAuth } from '../hooks/use-auth';
import { useTranslation } from 'react-i18next';
import '../ui/shared/lib/i18n';

interface I18nProviderProps {
  children: React.ReactNode;
}

export function I18nProvider({ children }: I18nProviderProps) {
  const { user } = useAuth();
  const { i18n } = useTranslation();
  const [isInitialized, setIsInitialized] = useState(false);

  useEffect(() => {
    const syncUserLanguage = async () => {
      console.log('I18nProvider - User email:', user?.email);
      console.log('I18nProvider - i18n.isInitialized:', i18n.isInitialized);
      console.log('I18nProvider - Current language:', i18n.language);
      
      if (user?.email && typeof window !== 'undefined' && i18n.isInitialized) {
        try {
          const response = await fetch(`/api/postgres/users?email=${encodeURIComponent(user.email)}`);
          if (response.ok) {
            const userData = await response.json();
            const userLanguage = userData.language || 'he'; // Default to Hebrew
            console.log('I18nProvider - User language from DB:', userLanguage);
            
            // Ensure the language is supported
            const supportedLanguages = ['he', 'en', 'ru', 'es', 'ar'];
            const finalLanguage = supportedLanguages.includes(userLanguage) ? userLanguage : 'he';
            
            if (i18n.language !== finalLanguage) {
              console.log('I18nProvider - Changing language from', i18n.language, 'to', finalLanguage);
              i18n.changeLanguage(finalLanguage);
            }
          }
        } catch (error) {
          console.error('Failed to fetch user language:', error);
          // Fallback to Hebrew if fetch fails
          if (i18n.language !== 'he') {
            console.log('I18nProvider - Fallback to Hebrew');
            i18n.changeLanguage('he');
          }
        }
      }
      setIsInitialized(true);
    };

    syncUserLanguage();
  }, [user?.email, i18n]);

  // Don't render children until i18n is initialized
  if (!isInitialized) {
    return <div>Loading...</div>;
  }

  return <>{children}</>;
} 