"use client";

import Link from 'next/link';
import { useRouter } from 'next/navigation';
import { useAuth } from '../../hooks/use-auth';
import { Button } from "../../components/ui/button";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "../../components/ui/card";
import { CheckCircle, LogIn } from 'lucide-react';

export default function LoggedOutPage() {
  return (
    <div className="main-container bg-gradient-to-br from-background to-green-50">
      <Card className="auth-card text-center shadow-xl">
        <CardHeader>
          <div className="mx-auto mb-6 flex h-20 w-20 items-center justify-center rounded-full bg-green-100 text-green-600">
            <CheckCircle className="h-12 w-12" />
          </div>
          <CardTitle className="text-3xl font-semibold">Successfully Logged Out</CardTitle>
          <CardDescription className="mt-2 text-muted-foreground">
            You have securely signed out of your MS4SC v1.0 account.
          </CardDescription>
        </CardHeader>
        <CardContent>
          <p className="mb-6 text-foreground">
            Thank you for using MS4SC v1.0. We hope to see you again soon!
          </p>
          <Button asChild className="w-full" variant="default">
            <Link href="/login">
              <LogIn className="mr-2 h-4 w-4" />
              Return to Login
            </Link>
          </Button>
        </CardContent>
      </Card>
    </div>
  );
}
