"use client";

import { useEffect } from 'react';
import { useRouter } from 'next/navigation';
import { useAuth } from '../../hooks/use-auth';
import { SplashScreen } from '../../components/splash-screen';
import MainDashboard from '../../user-panel/MainDashboard';
import SystemMainDashboard from '../../admin-panel/SystemMainDashboard';
import ManagerMainDashboard from '../../manager-panel/ManagerMainDashboard';

export default function DashboardPage() {
  const { user, loading, isAuthenticated, userRoleId } = useAuth();
  const router = useRouter();

  useEffect(() => {
    if (!loading && !isAuthenticated) {
      router.replace('/login');
    }
  }, [user, loading, isAuthenticated, router]);

  if (loading || !isAuthenticated) {
    return <SplashScreen />;
  }

  if (userRoleId === 0) {
    return <SystemMainDashboard />;
  }
  if (userRoleId === 1) {
    return <ManagerMainDashboard />;
  }
  return <MainDashboard />;
}
