import { NextResponse } from 'next/server';
import { pool } from '../../../../lib/db';

export async function GET() {
  try {
    // Простой тест подключения к базе данных
    const result = await pool.query('SELECT 1 as test');
    
    return NextResponse.json({ 
      success: true, 
      message: 'Database connection successful',
      test: result.rows[0].test,
      env: {
        host: process.env.POSTGRES_HOST,
        database: process.env.POSTGRES_DATABASE,
        user: process.env.POSTGRES_USER,
        port: process.env.POSTGRES_PORT
      }
    });
  } catch (error: any) {
    console.error('Database connection test failed:', error);
    return NextResponse.json({ 
      success: false, 
      error: error.message,
      env: {
        host: process.env.POSTGRES_HOST,
        database: process.env.POSTGRES_DATABASE,
        user: process.env.POSTGRES_USER,
        port: process.env.POSTGRES_PORT
      }
    }, { status: 500 });
  }
}
