import { NextResponse } from 'next/server';
import { postgresClient } from '../../../../lib/postgresql-client';

export async function GET() {
  try {
    // Количество пользователей
    const usersRes = await postgresClient.query('SELECT COUNT(*) FROM users');
    const usersCount = Number(usersRes.rows[0].count);

    // Количество устройств
    const devicesRes = await postgresClient.query('SELECT COUNT(*) FROM devices');
    const devicesCount = Number(devicesRes.rows[0].count);

    // Сумма использования воды (устройства с device_name начинающимся с 2310310)
    const waterUsageRes = await postgresClient.query(`
      SELECT COALESCE(SUM(dmv.current_value), 0) AS sum
      FROM devices d
      LEFT JOIN device_max_value dmv ON d.device_name = dmv.device_name
      WHERE d.device_name LIKE '2310310%'
    `);
    const waterUsage = Number(waterUsageRes.rows[0].sum);

    // Сумма использования электричества (устройства с meter_type=Electric meter)
    const electricUsageRes = await postgresClient.query(`
      SELECT COALESCE(SUM(dmv.current_value), 0) AS sum
      FROM devices d
      LEFT JOIN device_max_value dmv ON d.device_name = dmv.device_name
      WHERE d.meter_type = 'Electric meter'
    `);
    const electricUsage = Number(electricUsageRes.rows[0].sum);

    return NextResponse.json({ usersCount, devicesCount, waterUsage, electricUsage });
  } catch (error) {
    console.error('Error in /api/postgres/statistics:', error);
    return NextResponse.json({ error: 'Failed to fetch statistics' }, { status: 500 });
  }
} 