import { NextResponse } from 'next/server';
import { pool } from '../../../../lib/db';

export async function GET() {
  try {
    const result = await pool.query('SELECT relationship_name FROM relationship_type ORDER BY relationship_name');
    
    return NextResponse.json({ 
      success: true,
      relationshipTypes: result.rows
    });
  } catch (error: any) {
    console.error('Error fetching relationship types:', error);
    return NextResponse.json(
      { error: 'Failed to fetch relationship types' },
      { status: 500 }
    );
  }
}
