import { NextResponse } from 'next/server';
import { postgresClient } from '../../../../lib/postgresql-client';

export async function POST(request: Request) {
  try {
    const { user_id } = await request.json();
    if (!user_id) {
      return NextResponse.json({ error: 'user_id is required' }, { status: 400 });
    }
    const result = await postgresClient.query(
      'SELECT id, title, message, created_at FROM notifications WHERE user_id = $1 ORDER BY created_at DESC',
      [user_id]
    );
    return NextResponse.json({ notifications: result.rows });
  } catch (error) {
    console.error('Failed to fetch notifications:', error);
    return NextResponse.json({ error: 'Failed to fetch notifications' }, { status: 500 });
  }
} 