// Для локализации:
// "adminPanel.dashboard": "System Dashboard"
// "adminPanel.admin": "Admin"
// "adminPanel.config": "Configuration"
// "adminPanel.notifications": "Notifications"
// "adminPanel.approvals": "Pending Approvals"
// "adminPanel.roles": "Role Management"

import SystemAdminTab from './SystemAdminTab';
import SystemConfigurationCard from './SystemConfigurationCard';
import SystemDashboardTab from './SystemDashboardTab';
import SystemNotificationsTab from './SystemNotificationsTab';
import PendingApprovals from './PendingApprovals';
import RoleManagement from './RoleManagement';
import PendingOrdersTab from './PendingOrdersTab';

export const adminTabs = [
  { id: 'dashboard', label: 'adminPanel.dashboard', component: SystemDashboardTab },
  { id: 'admin', label: 'adminPanel.admin', component: SystemAdminTab },
  { id: 'config', label: 'adminPanel.config', component: SystemConfigurationCard },
  { id: 'notifications', label: 'adminPanel.notifications', component: SystemNotificationsTab },
  { id: 'approvals', label: 'adminPanel.approvals', component: PendingApprovals },
  { id: 'orders', label: 'adminPanel.pendingOrders', component: PendingOrdersTab },
  { id: 'roles', label: 'adminPanel.roles', component: RoleManagement },
]; 