import React, { useState } from 'react';
import { useTranslation } from 'react-i18next';
import { adminTabs } from './admin-tabs';
import ResponsiveTabs from './ResponsiveTabs';
import { MobileNavigation } from './MobileNavigation';

export default function SystemMainDashboard() {
  const { t } = useTranslation();
  const [activeTab, setActiveTab] = useState('dashboard');
  // Только нужные табы для обеих навигаций
  const filteredTabs = adminTabs.filter(tab => ['dashboard', 'admin', 'notifications', 'approvals', 'orders'].includes(tab.id));
  const tabItems = filteredTabs.map(tab => ({ id: tab.id, label: t(tab.label) }));
  const ActiveComponent = filteredTabs.find(tab => tab.id === activeTab)?.component;

  return (
    <div className="flex flex-col min-h-screen">
      {/* Desktop Tabs - только для lg+ экранов */}
      <div className="hidden lg:block w-full">
        <ResponsiveTabs tabs={tabItems} activeTab={activeTab} setActiveTab={setActiveTab} />
      </div>
      {/* Mobile/Tablet Navigation - только для <lg экранов */}
      <div className="lg:hidden w-full">
        <MobileNavigation tabs={tabItems} activeTab={activeTab} setActiveTab={setActiveTab} />
      </div>
      {/* Active tab content */}
      <main className="flex-1 overflow-x-auto p-1 sm:p-2 md:p-4 pb-20 lg:pb-4">
        {ActiveComponent && <ActiveComponent />}
      </main>
    </div>
  );
} 